<?php

/**
 * @StopForumSpam
 * 
 * Wrapper class for stopforumspam.com API. Uses json internally.
 *
 * @author Armin Rosu. Modified by sonnb [at] sonnb.com
 * @copyright 2011, Armin Rosu
 * @license http://www.opensource.org/licenses/BSD-3-Clause BSD 3-Clause License
 * @link http://www.stopforumspam.com/usage API Reference
 * @version 0.1
 */
class sonnbStopSpamHere_Model_StopForumSpam_Model_SFS
{

    /**
     * The Time Out.
     *
     * @var int
     */
    private static $timeout = 5;

    /**
     * The API key.
     *
     * @var string
     */
    private $api_key;

    /**
     * The base url, for tha API/
     *
     * @var string
     */
    private $endpoint = 'http://www.stopforumspam.com/';

    /**
     * Constructor.
     *
     * @param string $api_key Your API Key, optional (unless adding to database).
     */
    public function __construct($api_key = null)
    {
        // store variables
        $this->api_key = $api_key;
    }

    /**
     * Add to the database
     *
     * @param array $args associative array containing email, ip, username and optionally, evidence
     * e.g. $args = array('email' => 'user@example.com', 'ip_addr' => '8.8.8.8', 'username' => 'Spammer?', 'evidence' => 'My favourite website http://www.example.com' );
     * @return boolean Was the update succesfull or not.
     */
    public function add($args)
    {
        if (!isset($args['ip_addr']))
        {
        	if (isset($args['ip']))
        	{
        		$args['ip_addr'] = $args['ip'];
        		unset($args['ip']);
        	}
        	else
        	{
        		$args['ip_addr'] = '';
        	}
        }
              
        $args['api_key'] = $this->api_key;  
        
        // url to poll
        $url = $this->endpoint . 'add.php?' . http_build_query($args, '', '&');

        try
        {
	        $ctx = stream_context_create(array(
				'http' => array(
					'timeout' => self::$timeout
				)
			));
	
			// execute
			$response = file_get_contents($url, false, $ctx);
			
	        return (false == $response ? false : true);
        }
        catch (Exception $e)
        {
            return false;
        }
    }

    /**
     * Get record from spammers database.
     *
     * @param array $args associative array containing either one (or all) of these: username / email / ip.
     * e.g. $args = array('email' => 'user@example.com', 'ip' => '8.8.8.8', 'username' => 'Spammer?' );
     * @return object Response.
     */
    public function get($args)
    {
        $url = $this->endpoint . 'api?f=json&' . http_build_query($args, '', '&');

        // 
        return $this->poll_json($url);
    }

    /**
     * Check if either details correspond to a known spammer. Checking for username is discouraged.
     *
     * @param array $args associative array containing either one (or all) of these: username / email / ip
     * e.g. $data = array('email' => 'user@example.com', 'ip' => '8.8.8.8', 'username' => 'Spammer?' );
     * @return boolean
     */
    public function checkRegister($data)
    {
        // poll database
        $records = $this->get($data);

        // give the benefit of the doubt
        $spammer = array();
        
        if ($records && $records->success == true)
        {
            // parse database record
            foreach ($records as $field => $record)
            {
                // not 'success' datapoint AND spammer
                if (isset($record->appears) &&
                        $record->appears == true &&
                        isset($record->confidence) &&
                        $record->confidence >= 70)
                {
                    $spammer[$field] = $data[$field];
                }
            }
        }
        
        return $spammer;
    }

    /**
     * Get json and decode. Currently used for polling the database, but hoping for future 
     * json response support, when adding.
     *
     * @param string $url The url to get
     * @return object Response.
     */
    protected static function poll_json($url)
    {
        try
        {
            $ctx = stream_context_create(array(
                'http' => array(
                    'timeout' => self::$timeout
                )
                    )
            );

            // execute
            $json = file_get_contents($url, false, $ctx);
            $object = json_decode($json);
            
            return $object;
        }
        catch (Exception $e)
        {
            return false;
        }
    }

}

?>